********************************************************************************
* PROGRAMMER: DOS
* PROJECT:    EANNA 2023
* PURPOSE:    Indicador de Trabajo Infantil 2023
* LAST UPDATE:Diciembre 2024
* INPUT:      BASE EANNA 2023
********************************************************************************
	/* Antes de cargar la base se recomienda usar los siguientes comando 
	clear all
	set more off 
	 * Recuerde descomprimir base. Para cargar Base de datos EANNA 2023.dta puede seguir el siguiente ejemplo: 
	use "D:\resultados eanna\base pública\Base de datos EANNA 2023.dta", clear
	*/
***********************************************************************
* SECCION TIEMPO SOLO 9-17: HOMOLOGAR/TRANSFORMAR A VALOR NUMERICO TIEMPO QUE HACE ACTIVIDAD Y LIMPIAR 88 (no sabe - sin dato)
***********************************************************************
*limpiar para tiempo -98 (no sabe - sin dato)
replace a14_10_dias=. if a14_10_dias==-98

*[modulo actividades economicas] homologar y transformar a valor numerico tiempo que hace actividad - edad 9 a 17 
local i=36
foreach l in lu ma mi ju vi sa do {
gen min`l'=real(substr(a`i',4,5))	//crear minutos por dia: lunes martes miercoles jueves viernes sabado domingo
gen hrs`l'=real(substr(a`i',1,2))	//crear horas por dia: lunes martes miercoles jueves viernes sabado domingo
local ++i
}
*LIMPIAR VARIABLES 88 (no sabe - sin dato) A MISSING PRIMERO PARA POSTERIORMENETE TRANSFORMAR MINUTOS A HORAS PARA PODER SUMAR Y CREAR VARIABLE TIEMPO
foreach l in lu ma mi ju vi sa do {
replace min`l'=. if min`l'==88		//limpiar variable minutos
replace hrs`l'=. if hrs`l'==88		//limpiar variable horas
replace min`l'=min`l'/60			//cambio formato: pasar minutos a horas
}
*[modulo tareas del hogar] homologar y transformar a valor numerico tiempo que hace actividad - edad 9 a 17 
foreach n of numlist 1/12 77 {
gen min`n' =real(substr(a14_`n'_tiempo,4,5)) //crear minutos por actividad
gen hrs`n' =real(substr(a14_`n'_tiempo,1,2)) //crear horas por actividad
}
*LIMPIAR VARIABLES 88 (no sabe - sin dato) A MISSING PRIMERO PARA POSTERIORMENETE TRANSFORMAR MINUTOS A HORAS PARA PODER SUMAR Y CREAR VARIABLE TIEMPO
foreach n of numlist 1/12 77 {
replace min`n'=. if min`n'==88 				//limpiar variable minutos
replace hrs`n'=. if hrs`n'==88 				//limpiar variable horas
replace min`n'=min`n'/60 					//cambio formato: pasar minutos a horas
}
***********************************************************************
* SECCION TIEMPO 
*AE: horas al día (td_e) y a la semana (tt_e)
***********************************************************************
*crear variable por dia (suma horas y minutos)
foreach l in lu ma mi ju vi sa do {
egen t`l'=rsum(hrs`l' min`l'), missing 					//total por día: suma horas y minutos
}
*crear variable horas a la semana: sumando lunes a domingo
egen tt_e=rsum(tlu tma tmi tju tvi tsa tdo), missing 	//total por semana: suma los totales diarios 
*crear variable horas de un dia: se selecciona el dia con mas horas entre lunes a domingo, esta variable se usa para medir tp_4 (tiempo prolongado)
egen td_e=rmax(tlu tma tmi tju tvi tsa tdo) 			//valor maximo de tiempo de un día durante la semana


***********************************************************************
* SECCION TIEMPO 
*TH: *es necesario el paso previo de calcular el tiempo por actividad segun formas de trabajo
***********************************************************************
*solo variables/actividades que se pueden clasificar en ocupacion/voluntario/autoconsumo debido a que reportan destino y pago  
egen tdia_1=rsum(min1 hrs1)
egen tdia_ocup1=rsum(min1 hrs1) if a14_1_destino==2 & a14_1_pago==1 		//directo FP
egen tdia_vol1=rsum(min1 hrs1) if a14_1_destino==2 & a14_1_pago==2 			//vol de servicios (FGP)
egen tdia_aut1=rsum(min1 hrs1) if a14_1_destino==1 							//aut de servicios (FGP)

egen tdia_aut2=rsum(min2 hrs2) 					 							//directo aut de servicios (FGP)
egen tdia_aut3=rsum(min3 hrs3) 					 							//directo aut de servicios (FGP)
egen tdia_aut4=rsum(min4 hrs4) 					 							//directo aut de servicios (FGP)

egen tdia_ocup5=rsum(min5 hrs5) if a14_5_destino==2 & a14_5_pago==1 		//directo FP
egen tdia_vol5=rsum(min5 hrs5) if a14_5_destino==2 & a14_5_pago==2 			//vol de servicios (FGP)
egen tdia_aut5=rsum(min5 hrs5) if a14_5_destino==1 							//aut de servicios (FGP)

egen tdia_ocup6=rsum(min6 hrs6) if a14_6_destino==2 & a14_6_pago==1 		//directo FP
egen tdia_vol6=rsum(min6 hrs6) if a14_6_destino==2 & a14_6_pago==2 			//vol de bienes (FP)
egen tdia_aut6=rsum(min6 hrs6) if a14_6_destino==1 							//auto de bienes (FP)

egen tdia_ocup7=rsum(min7 hrs7) if a14_7_destino==2 & a14_7_pago==1 		//directo FP
egen tdia_vol7=rsum(min7 hrs7) if a14_7_destino==2 & a14_7_pago==2			//vol de servicios (FGP)
egen tdia_aut7=rsum(min7 hrs7) if a14_7_destino==1							//aut de servicios (FGP)

egen tdia_aut8=rsum(min8 hrs8) 					 							//directo aut de servicios (FGP)
egen tdia_aut9=rsum(min9 hrs9) 					 							//directo aut de servicios (FGP)
egen tdia_aut10=rsum(min10 hrs10)				 							//directo aut de servicios (FGP)

egen tdia_ocup11=rsum(min11 hrs11) if a14_11_destino==2 & a14_11_pago==1 	//directo FP
egen tdia_vol11=rsum(min11 hrs11) if a14_11_destino==2 & a14_11_pago==2 	//vol de bienes (FP)
egen tdia_aut11=rsum(min11 hrs11) if a14_11_destino==1 						//auto de bienes (FP)

egen tdia_ocup12=rsum(min12 hrs12) if a14_12_destino==2 & a14_12_pago==1 	//directo FP
egen tdia_vol12=rsum(min12 hrs12) if a14_12_destino==2 & a14_12_pago==2 	//vol de bienes (FP)
egen tdia_aut12=rsum(min12 hrs12) if a14_12_destino==1						//auto de bienes (FP)

egen tdia_ocup77=rsum(min77 hrs77) if a14_77_destino==2 & a14_12_pago==1 	//directo FP
egen tdia_vol77=rsum(min77 hrs77) if a14_77_destino==2 & a14_12_pago==2 	//definir por glosa si es bien o servicio 
egen tdia_aut77=rsum(min77 hrs77) if a14_77_destino==1						//definir por glosa si es bien o servicio

***********************************************************************
*REVISION glosa 77 modulo Tareas Hogar: definiendo si es autoconsumo de bienes o servicios
***********************************************************************
gen    th77_ab=. //En revision no se registra ninguna glosa de autoconsumo de bienes
gen    th77_as=.
foreach i in "EANNA_011827" "EANNA_012800" "EANNA_013398" "EANNA_013402" "EANNA_013808" "EANNA_014398" "EANNA_014861" "EANNA_015006" "EANNA_015123" "EANNA_015148" "EANNA_0152" "EANNA_015228" "EANNA_015350" "EANNA_016237" "EANNA_016379" "EANNA_016997" "EANNA_02017" "EANNA_02768" "EANNA_02841" "EANNA_04847" "EANNA_05245" "EANNA_05677" "EANNA_05740" "EANNA_07067" "EANNA_07437" "EANNA_07964" "EANNA_08198" "EANNA_08492" "EANNA_08806" "EANNA_09540" "EANNA_09573" {
replace    th77_as=1 if nna_selec==1 & folio=="`i'"
}

***********************************************************************
* SECCION TIEMPO TH: horas al día (td_h_ocu td_h_autb td_h_volb td_h_auts td_h_vols) y a la semana (tt_h_ocu tt_h_autb tt_h_volb tt_h_auts tt_h_vols)
***********************************************************************
*crear variable horas a la semana: sumando actividades segun forma de trabajo
*cocina
 gen 	tt_cocina=a14_1_dias*tdia_1
*ocupado 
 gen 	aux1=a14_1_dias*tdia_ocup1					//genero auxiliar para crear tt_h_ocu con egen y poder sumar aunque hayan missing
 gen 	aux2=a14_5_dias*tdia_ocup5					//idem
 gen 	aux3=a14_6_dias*tdia_ocup6					//idem
 gen 	aux4=a14_7_dias*tdia_ocup7					//idem
 gen 	aux5=a14_11_dias*tdia_ocup11				//idem
 gen 	aux6=a14_12_dias*tdia_ocup12				//idem
 gen 	aux7=a14_77_dias*tdia_ocup77				//idem
egen 	tt_h_ocu=rsum(aux1 aux2 aux3 aux4 aux5 aux6 aux7), missing //horas a la semana ocupacion modulo tareas del hogar
drop aux*
*autoconsumo (de bienes)
 gen 	aux1=a14_6_dias*tdia_aut6					 //genero auxiliar para crear tt_aut_h con egen y poder sumar aunque hayan missing
 gen 	aux2=a14_11_dias*tdia_aut11					 //idem
 gen 	aux3=a14_12_dias*tdia_aut12					 //idem
 gen 	aux4=a14_77_dias*tdia_aut77	if th77_ab==1 	 //utiliza th77_ab por revision de glosa (sin observaciones) 
egen 	tt_h_autb=rsum(aux1 aux2 aux3 aux4), missing //horas a la semana autoconsumo bienes modulo tareas del hogar
drop aux*
*voluntario (de bienes)
 gen 	aux1=a14_6_dias*tdia_vol6					 //genero auxiliar para crear tt_aut_h con egen y poder sumar aunque hayan missing
 gen 	aux2=a14_11_dias*tdia_vol11					 //idem
 gen 	aux3=a14_12_dias*tdia_vol12					 //idem
 gen 	aux4=a14_77_dias*tdia_vol77					 //sin observaciones (no hay glosas a revisar)
egen 	tt_h_volb=rsum(aux1 aux2 aux3 aux4), missing //horas a la semana voluntario bienes modulo tareas del hogar
drop aux*
*autoconsumo (de servicios) servicios domesticos no remunerados
 gen 	aux1=a14_1_dias*tdia_aut1					//genero auxiliar para crear tt_aut_h con egen y poder sumar aunque hayan missing
 gen 	aux2=a14_2_dias*tdia_aut2					//idem
 gen 	aux3=a14_3_dias*tdia_aut3					//idem
 gen 	aux4=a14_4_dias*tdia_aut4					//idem
 gen 	aux5=a14_5_dias*tdia_aut5					//idem
 gen 	aux6=a14_7_dias*tdia_aut7					//idem
 gen 	aux7=a14_8_dias*tdia_aut8					//idem
 gen 	aux8=a14_9_dias*tdia_aut9					//idem
 gen 	aux9=a14_10_dias*tdia_aut10					//idem
 gen 	aux10=a14_77_dias*tdia_aut77 if th77_as==1  //utiliza th77_as por revision de glosa
egen 	tt_h_auts=rsum(aux1 aux2 aux3 aux4 aux5 aux6 aux7 aux8 aux9 aux10), missing	//horas a la semana autoconsumo servicios modulo tareas del hogar
drop aux*
*voluntario (de servicios)
 gen 	aux1=a14_1_dias*tdia_vol1					 //genero auxiliar para crear tt_h_vols con egen y poder sumar aunque hayan missing
 gen 	aux2=a14_5_dias*tdia_vol5					 //genero auxiliar para crear tt_h_vols con egen y poder sumar aunque hayan missing
 gen 	aux3=a14_7_dias*tdia_vol7					 //idem
 gen 	aux4=a14_77_dias*tdia_vol77					 //sin observaciones (no hay glosas a revisar)
egen 	tt_h_vols=rsum(aux1 aux2 aux3 aux4), missing //horas a la semana voluntario servicios modulo tareas del hogar
drop aux*

*trabajo de servicios no remunerado (tsnr)
egen 	tt_h_tsnr=rsum(tt_h_auts tt_h_vols), missing //horas a la semana trabajo de servicios no remunerado (tsnr) modulo tareas del hogar

*crear variable max horas de un dia:
egen tdmax_h_ocu =rmax(tdia_ocup1 tdia_ocup5 tdia_ocup6 tdia_ocup7 tdia_ocup11 tdia_ocup12 tdia_ocup77)
gen  aux77=a14_77_dias*tdia_aut77	if th77_ab==1 	 //todos los 77 de th se clasifican como autoconsumo de bienes
egen tdmax_h_autb=rmax(tdia_aut6 tdia_aut11 tdia_aut12 aux77) 			
egen tdmax_h_volb=rmax(tdia_vol6 tdia_vol11 tdia_vol12) 			

*crear estimacion horas de un dia: segun forma de trabajo se divide por 7 (por los dias de la semana) el valor de horas a la semana, esta variable se usa para medir tp4 (tiempo prolongado)
gen td_h_ocu= tt_h_ocu /7
gen td_h_autb=tt_h_autb/7 
gen td_h_volb=tt_h_volb/7
gen td_h_auts=tt_h_auts/7
gen td_h_vols=tt_h_vols/7

gen td_h_tsnr=tt_h_tsnr/7

